/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Point;

import intrinsic.Function;
import intrinsic.flash.display.Bitmap;
import intrinsic.flash.events.IEventDispatcher;
import intrinsic.mx.core.*;
import intrinsic.mx.controls.*;
import intrinsic.mx.containers.*;

public class Label extends Control {
	String text = "";
	org.eclipse.swt.graphics.Image image;

	UIComponent labelObject;
	UIComponent imageObject;

public Label (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public Point computeSize (int wHint, int hHint, boolean changed) {
	checkWidget ();
	if ((style & SWT.SEPARATOR) != 0) {
		return computeNativeSize(object, wHint, hHint, changed);
	}
	UIComponent widget = labelObject.includeInLayout ? labelObject : imageObject;
	widget.validateProperties();
	widget.validateSize();
	int width = wHint == SWT.DEFAULT ? (int)widget.measuredWidth : wHint;
	int height = hHint == SWT.DEFAULT ? (int)widget.measuredHeight : hHint;
	return new Point(width, height);
}

void createHandle () {
	if ((style & SWT.SEPARATOR) != 0) {
		if ((style & SWT.VERTICAL) != 0) {
			object = new VRule();
		} else {
			object = new HRule();
		}
	} else {
		HBox widget = new HBox();
		intrinsic.mx.controls.Label labelWidget = new intrinsic.mx.controls.Label();
		labelWidget.percentHeight = labelWidget.percentWidth = 100;
		labelObject = labelWidget;
		intrinsic.mx.controls.Image imageWidget = new intrinsic.mx.controls.Image();
		imageWidget.scaleContent = false;
		imageWidget.visible = false;
		imageWidget.includeInLayout = false;
		imageWidget.percentHeight = imageWidget.percentWidth = 100;
		imageObject = imageWidget;
		widget.horizontalScrollPolicy = ScrollPolicy.OFF;
		widget.verticalScrollPolicy = ScrollPolicy.OFF;
		widget.addChild(imageObject);
		widget.addChild(labelObject);
		object = widget;
		setAlignment(style);
	}
}

public int getAlignment () {
	checkWidget ();
	if ((style & SWT.SEPARATOR) != 0) return 0;
	if ((style & SWT.LEFT) != 0) return SWT.LEFT;
	if ((style & SWT.CENTER) != 0) return SWT.CENTER;
	if ((style & SWT.RIGHT) != 0) return SWT.RIGHT;
	return SWT.LEFT;
}

public org.eclipse.swt.graphics.Image getImage () {
	checkWidget ();
	return image;
}

String getNameText () {
	return getText ();
}

public String getText () {
	checkWidget ();
	return text;
}

public void setAlignment (int alignment) {
	checkWidget ();
	if ((style & SWT.SEPARATOR) != 0) return;
	if ((alignment & (SWT.LEFT | SWT.RIGHT | SWT.CENTER)) == 0) return;
	style &= ~(SWT.LEFT | SWT.RIGHT | SWT.CENTER);
	style |= alignment & (SWT.LEFT | SWT.RIGHT | SWT.CENTER);
	imageObject.setStyle("verticalAlign", "middle");
	if ((alignment & SWT.RIGHT) != 0) {
		labelObject.setStyle("textAlign", "right");
		imageObject.setStyle("horizontalAlign", "right");
	} else if ((alignment & SWT.CENTER) != 0) {
		labelObject.setStyle("textAlign", "center");
		imageObject.setStyle("horizontalAlign", "center");
	} else {
		labelObject.setStyle("textAlign", "left");
		imageObject.setStyle("horizontalAlign", "left");
	}
}

public void setImage (org.eclipse.swt.graphics.Image image) {
	checkWidget ();
	if (image != null && image.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
	if ((style & SWT.SEPARATOR) != 0) return;
	org.eclipse.swt.graphics.Image oldImage = this.image;
	if (oldImage == image) return;
	this.image = image;
	if (image != null) {
		if (image.object != null) {
			((intrinsic.mx.controls.Image)imageObject).source = new Bitmap(image.object);
		} else {
			image.listener.addEventListener(intrinsic.flash.events.Event.COMPLETE, completeHandlerFunction ());
		}
	} else {
		((intrinsic.mx.controls.Image)imageObject).source = null;
	}
	labelObject.visible = image == null;
	imageObject.visible = image != null;
	labelObject.includeInLayout = image == null;	
	imageObject.includeInLayout = image != null;
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	if ((style & SWT.SEPARATOR) != 0) {
		style = checkBits (style, SWT.VERTICAL, SWT.HORIZONTAL, 0, 0, 0, 0);
		return checkBits (style, SWT.SHADOW_OUT, SWT.SHADOW_IN, SWT.SHADOW_NONE, 0, 0, 0);
	} 
	return checkBits (style, SWT.LEFT, SWT.CENTER, SWT.RIGHT, 0, 0, 0);
}

void completeHandler(intrinsic.flash.events.Event event) {
	if (image != null) ((intrinsic.mx.controls.Image)imageObject).source = new Bitmap(image.object);
	((IEventDispatcher)event.target).removeEventListener (intrinsic.flash.events.Event.COMPLETE, completeHandlerFunction ());
}

native Function completeHandlerFunction ()/*{
	return completeHandler__Lflash_events_Event_2;
}*/;

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if ((style & SWT.SEPARATOR) != 0) return;
	text = string;
	((intrinsic.mx.controls.Label)labelObject).text = fixMnemonic (string);
	labelObject.visible = true;
	imageObject.visible = false;
	labelObject.includeInLayout = true;	
	imageObject.includeInLayout = false;
}
}
